@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The EngagementFabric SKU
 * @property name The name of the SKU
 * @property tier The price tier of the SKU
 */
public data class SKUResponse(
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.engagementfabric.outputs.SKUResponse):
            SKUResponse = SKUResponse(
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
