@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin

import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.EnterpriseKnowledgeGraphPropertiesResponse
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.EnterpriseKnowledgeGraphPropertiesResponse.Companion.toKotlin as enterpriseKnowledgeGraphPropertiesResponseToKotlin
import com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [EnterpriseKnowledgeGraph].
 */
@PulumiTagMarker
public class EnterpriseKnowledgeGraphResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterpriseKnowledgeGraphArgs = EnterpriseKnowledgeGraphArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterpriseKnowledgeGraphArgsBuilder.() -> Unit) {
        val builder = EnterpriseKnowledgeGraphArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EnterpriseKnowledgeGraph {
        val builtJavaResource =
            com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraph(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnterpriseKnowledgeGraph(builtJavaResource)
    }
}

/**
 * EnterpriseKnowledgeGraph resource definition
 * Azure REST API version: 2018-12-03. Prior API version in Azure Native 1.x: 2018-12-03.
 * ## Example Usage
 * ### Create EnterpriseKnowledgeGraph
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enterpriseKnowledgeGraph = new AzureNative.EnterpriseKnowledgeGraph.EnterpriseKnowledgeGraph("enterpriseKnowledgeGraph", new()
 *     {
 *         Location = "West US",
 *         Properties = null,
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "sampleekgname",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/enterpriseknowledgegraph/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := enterpriseknowledgegraph.NewEnterpriseKnowledgeGraph(ctx, "enterpriseKnowledgeGraph", &enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs{
 * 			Location:          pulumi.String("West US"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("sampleekgname"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraph;
 * import com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enterpriseKnowledgeGraph = new EnterpriseKnowledgeGraph("enterpriseKnowledgeGraph", EnterpriseKnowledgeGraphArgs.builder()
 *             .location("West US")
 *             .properties()
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("sampleekgname")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:enterpriseknowledgegraph:EnterpriseKnowledgeGraph samplename /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EnterpriseKnowledgeGraph/services/{resourceName}
 * ```
 */
public class EnterpriseKnowledgeGraph internal constructor(
    override val javaResource:
    com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraph,
) : KotlinCustomResource(javaResource, EnterpriseKnowledgeGraphMapper) {
    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of properties specific to EnterpriseKnowledgeGraph resource
     */
    public val properties: Output<EnterpriseKnowledgeGraphPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                enterpriseKnowledgeGraphPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnterpriseKnowledgeGraphMapper : ResourceMapper<EnterpriseKnowledgeGraph> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraph::class == javaResource::class

    override fun map(javaResource: Resource): EnterpriseKnowledgeGraph =
        EnterpriseKnowledgeGraph(
            javaResource as
                com.pulumi.azurenative.enterpriseknowledgegraph.EnterpriseKnowledgeGraph,
        )
}

/**
 * @see [EnterpriseKnowledgeGraph].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterpriseKnowledgeGraph].
 */
public suspend fun enterpriseKnowledgeGraph(
    name: String,
    block: suspend EnterpriseKnowledgeGraphResourceBuilder.() -> Unit,
): EnterpriseKnowledgeGraph {
    val builder = EnterpriseKnowledgeGraphResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterpriseKnowledgeGraph].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterpriseKnowledgeGraph(name: String): EnterpriseKnowledgeGraph {
    val builder = EnterpriseKnowledgeGraphResourceBuilder()
    builder.name(name)
    return builder.build()
}
