@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.ClientGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Client group resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### ClientGroups_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clientGroup = new AzureNative.EventGrid.ClientGroup("clientGroup", new()
 *     {
 *         ClientGroupName = "exampleClientGroupName1",
 *         Description = "This is a test client group",
 *         NamespaceName = "exampleNamespaceName1",
 *         Query = "attributes.b IN ['a', 'b', 'c']",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewClientGroup(ctx, "clientGroup", &eventgrid.ClientGroupArgs{
 * 			ClientGroupName:   pulumi.String("exampleClientGroupName1"),
 * 			Description:       pulumi.String("This is a test client group"),
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			Query:             pulumi.String("attributes.b IN ['a', 'b', 'c']"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.ClientGroup;
 * import com.pulumi.azurenative.eventgrid.ClientGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clientGroup = new ClientGroup("clientGroup", ClientGroupArgs.builder()
 *             .clientGroupName("exampleClientGroupName1")
 *             .description("This is a test client group")
 *             .namespaceName("exampleNamespaceName1")
 *             .query("attributes.b IN ['a', 'b', 'c']")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:ClientGroup exampleClientGroupName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/clientGroups/{clientGroupName}
 * ```
 * @property clientGroupName The client group name.
 * @property description Description for the Client Group resource.
 * @property namespaceName Name of the namespace.
 * @property query The grouping query for the clients.
 * Example : attributes.keyName IN ['a', 'b', 'c'].
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class ClientGroupArgs(
    public val clientGroupName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val query: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.ClientGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.ClientGroupArgs =
        com.pulumi.azurenative.eventgrid.ClientGroupArgs.builder()
            .clientGroupName(clientGroupName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientGroupArgs].
 */
@PulumiTagMarker
public class ClientGroupArgsBuilder internal constructor() {
    private var clientGroupName: Output<String>? = null

    private var description: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var query: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The client group name.
     */
    @JvmName("tewgxksfnbmdrpsp")
    public suspend fun clientGroupName(`value`: Output<String>) {
        this.clientGroupName = value
    }

    /**
     * @param value Description for the Client Group resource.
     */
    @JvmName("atbqcbnnmpscvkyt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("rvhnqsioomqasdbu")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The grouping query for the clients.
     * Example : attributes.keyName IN ['a', 'b', 'c'].
     */
    @JvmName("txpciiwksasrhvve")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("hnniodqxlieanapw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The client group name.
     */
    @JvmName("gvvsxyxbyirriiex")
    public suspend fun clientGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientGroupName = mapped
    }

    /**
     * @param value Description for the Client Group resource.
     */
    @JvmName("agbpbxxjsjyuohna")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("rhjmwctwybtttqky")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The grouping query for the clients.
     * Example : attributes.keyName IN ['a', 'b', 'c'].
     */
    @JvmName("nueqepwgyceunsiu")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("nuomnmhoiawhxcaw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ClientGroupArgs = ClientGroupArgs(
        clientGroupName = clientGroupName,
        description = description,
        namespaceName = namespaceName,
        query = query,
        resourceGroupName = resourceGroupName,
    )
}
