@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.NamespaceArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.eventgrid.kotlin.enums.TlsVersion
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.InboundIpRuleArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.NamespaceSkuArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.NamespaceSkuArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.TopicSpacesConfigurationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.TopicSpacesConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Namespace resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### Namespaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @namespace = new AzureNative.EventGrid.Namespace("namespace", new()
 *     {
 *         Location = "westus",
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "tag1", "value11" },
 *             { "tag2", "value22" },
 *         },
 *         TopicSpacesConfiguration = new AzureNative.EventGrid.Inputs.TopicSpacesConfigurationArgs
 *         {
 *             RouteTopicResourceId = "/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampleTopic1",
 *             State = "Enabled",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewNamespace(ctx, "namespace", &eventgrid.NamespaceArgs{
 * 			Location:          pulumi.String("westus"),
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value11"),
 * 				"tag2": pulumi.String("value22"),
 * 			},
 * 			TopicSpacesConfiguration: &eventgrid.TopicSpacesConfigurationArgs{
 * 				RouteTopicResourceId: pulumi.String("/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampleTopic1"),
 * 				State:                pulumi.String("Enabled"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.Namespace;
 * import com.pulumi.azurenative.eventgrid.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespace = new Namespace("namespace", NamespaceArgs.builder()
 *             .location("westus")
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value11"),
 *                 Map.entry("tag2", "value22")
 *             ))
 *             .topicSpacesConfiguration(Map.ofEntries(
 *                 Map.entry("routeTopicResourceId", "/subscriptions/8f6b6269-84f2-4d09-9e31-1127efcd1e40/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampleTopic1"),
 *                 Map.entry("state", "Enabled")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:Namespace exampleNamespaceName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}
 * ```
 * @property identity Identity information for the Namespace resource.
 * @property inboundIpRules This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
 * @property isZoneRedundant Allows the user to specify if the service is zone-redundant. This is a required property and user needs to specify this value explicitly.
 * Once specified, this property cannot be updated.
 * @property location Location of the resource.
 * @property minimumTlsVersionAllowed Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
 * @property namespaceName Name of the namespace.
 * @property privateEndpointConnections
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property sku Represents available Sku pricing tiers.
 * @property tags Tags of the resource.
 * @property topicSpacesConfiguration Topic spaces configuration information for the namespace resource
 */
public data class NamespaceArgs(
    public val identity: Output<IdentityInfoArgs>? = null,
    public val inboundIpRules: Output<List<InboundIpRuleArgs>>? = null,
    public val isZoneRedundant: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersionAllowed: Output<Either<String, TlsVersion>>? = null,
    public val namespaceName: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<NamespaceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topicSpacesConfiguration: Output<TopicSpacesConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.NamespaceArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.NamespaceArgs =
        com.pulumi.azurenative.eventgrid.NamespaceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inboundIpRules(
                inboundIpRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .isZoneRedundant(isZoneRedundant?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersionAllowed(
                minimumTlsVersionAllowed?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicSpacesConfiguration(
                topicSpacesConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var identity: Output<IdentityInfoArgs>? = null

    private var inboundIpRules: Output<List<InboundIpRuleArgs>>? = null

    private var isZoneRedundant: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersionAllowed: Output<Either<String, TlsVersion>>? = null

    private var namespaceName: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<NamespaceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicSpacesConfiguration: Output<TopicSpacesConfigurationArgs>? = null

    /**
     * @param value Identity information for the Namespace resource.
     */
    @JvmName("urtpletytalaioab")
    public suspend fun identity(`value`: Output<IdentityInfoArgs>) {
        this.identity = value
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("iapxfhgojtighjwn")
    public suspend fun inboundIpRules(`value`: Output<List<InboundIpRuleArgs>>) {
        this.inboundIpRules = value
    }

    @JvmName("nhohtwxmafrkmxse")
    public suspend fun inboundIpRules(vararg values: Output<InboundIpRuleArgs>) {
        this.inboundIpRules = Output.all(values.asList())
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("tcybximnobjgkmpu")
    public suspend fun inboundIpRules(values: List<Output<InboundIpRuleArgs>>) {
        this.inboundIpRules = Output.all(values)
    }

    /**
     * @param value Allows the user to specify if the service is zone-redundant. This is a required property and user needs to specify this value explicitly.
     * Once specified, this property cannot be updated.
     */
    @JvmName("ijptferqjqyjybhm")
    public suspend fun isZoneRedundant(`value`: Output<Boolean>) {
        this.isZoneRedundant = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("xygbcrukjvkpvcdc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
     */
    @JvmName("ibwgrxoofqxqujte")
    public suspend fun minimumTlsVersionAllowed(`value`: Output<Either<String, TlsVersion>>) {
        this.minimumTlsVersionAllowed = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("plmiwjuvpyvodaya")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value
     */
    @JvmName("nbkbdcwowipwtern")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("jatkghrcveveldxt")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xulxpkbovabbtuvx")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
     */
    @JvmName("ivqoljfrnrufdqau")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("xpmaquxjyfrtvavi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Represents available Sku pricing tiers.
     */
    @JvmName("bratlaqwgwosrfgm")
    public suspend fun sku(`value`: Output<NamespaceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("lsxjouhcnlsmfxka")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Topic spaces configuration information for the namespace resource
     */
    @JvmName("qvtllcbsqiydreci")
    public suspend fun topicSpacesConfiguration(`value`: Output<TopicSpacesConfigurationArgs>) {
        this.topicSpacesConfiguration = value
    }

    /**
     * @param value Identity information for the Namespace resource.
     */
    @JvmName("xstgorwsbdaobbcx")
    public suspend fun identity(`value`: IdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity information for the Namespace resource.
     */
    @JvmName("ytfiovdvitckgvog")
    public suspend fun identity(argument: suspend IdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("dijfkdodgrbvpfka")
    public suspend fun inboundIpRules(`value`: List<InboundIpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("csiiodgkwaxxnaju")
    public suspend fun inboundIpRules(argument: List<suspend InboundIpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("fdyturteconiuawg")
    public suspend fun inboundIpRules(vararg argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InboundIpRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param argument This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("nghddrbyyoumjofn")
    public suspend fun inboundIpRules(argument: suspend InboundIpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundIpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundIpRules = mapped
    }

    /**
     * @param values This can be used to restrict traffic from specific IPs instead of all IPs. Note: These are considered only if PublicNetworkAccess is enabled.
     */
    @JvmName("tylqhhotqdailqox")
    public suspend fun inboundIpRules(vararg values: InboundIpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundIpRules = mapped
    }

    /**
     * @param value Allows the user to specify if the service is zone-redundant. This is a required property and user needs to specify this value explicitly.
     * Once specified, this property cannot be updated.
     */
    @JvmName("jvacnjpklcfibeyy")
    public suspend fun isZoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isZoneRedundant = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("fwcgntgrjujpfdwh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
     */
    @JvmName("ftsqukvrbvdxwqrf")
    public suspend fun minimumTlsVersionAllowed(`value`: Either<String, TlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersionAllowed = mapped
    }

    /**
     * @param value Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
     */
    @JvmName("ouwdaklfsslcwedv")
    public fun minimumTlsVersionAllowed(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersionAllowed = mapped
    }

    /**
     * @param value Minimum TLS version of the publisher allowed to publish to this namespace. Only TLS version 1.2 is supported.
     */
    @JvmName("hsevxafaxcakcaul")
    public fun minimumTlsVersionAllowed(`value`: TlsVersion) {
        val toBeMapped = Either.ofRight<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersionAllowed = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("katfnhbsforsvbak")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("smrhbkaeapkehgjd")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wdjxbabbornocjls")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yshwcniifynmhgeu")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vkapyopnuxdnosst")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values
     */
    @JvmName("wuomhgagtaaiqwyr")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
     */
    @JvmName("yrwqmbomyircjuyl")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
     */
    @JvmName("rdkthvukdyuswmxl")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     * You can further restrict to specific IPs by configuring <seealso cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.PubSub.NamespaceProperties.InboundIpRules" />
     */
    @JvmName("vwxthmopjcmvyued")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("gbsfhvjkoqboasam")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Represents available Sku pricing tiers.
     */
    @JvmName("vofbfwuyunivvufm")
    public suspend fun sku(`value`: NamespaceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Represents available Sku pricing tiers.
     */
    @JvmName("avfbfnxixiufglfx")
    public suspend fun sku(argument: suspend NamespaceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = NamespaceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("bjscuccjiofrnkdb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("ewbyvfnmbeqgpsxj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Topic spaces configuration information for the namespace resource
     */
    @JvmName("xigawyukyaspkrcp")
    public suspend fun topicSpacesConfiguration(`value`: TopicSpacesConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicSpacesConfiguration = mapped
    }

    /**
     * @param argument Topic spaces configuration information for the namespace resource
     */
    @JvmName("fjtholrsklwsjskg")
    public suspend
    fun topicSpacesConfiguration(argument: suspend TopicSpacesConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TopicSpacesConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.topicSpacesConfiguration = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        identity = identity,
        inboundIpRules = inboundIpRules,
        isZoneRedundant = isZoneRedundant,
        location = location,
        minimumTlsVersionAllowed = minimumTlsVersionAllowed,
        namespaceName = namespaceName,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        topicSpacesConfiguration = topicSpacesConfiguration,
    )
}
