@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PartnerConfigurationArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.PartnerConfigurationProvisioningState
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PartnerAuthorizationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PartnerAuthorizationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Partner configuration information
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerConfigurations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerConfiguration = new AzureNative.EventGrid.PartnerConfiguration("partnerConfiguration", new()
 *     {
 *         PartnerAuthorization = new AzureNative.EventGrid.Inputs.PartnerAuthorizationArgs
 *         {
 *             AuthorizedPartnersList = new[]
 *             {
 *                 new AzureNative.EventGrid.Inputs.PartnerArgs
 *                 {
 *                     AuthorizationExpirationTimeInUtc = "2022-01-28T01:20:55.142Z",
 *                     PartnerName = "Contoso.Finance",
 *                     PartnerRegistrationImmutableId = "941892bc-f5d0-4d1c-8fb5-477570fc2b71",
 *                 },
 *                 new AzureNative.EventGrid.Inputs.PartnerArgs
 *                 {
 *                     AuthorizationExpirationTimeInUtc = "2022-02-20T01:00:00.142Z",
 *                     PartnerName = "fabrikam.HR",
 *                     PartnerRegistrationImmutableId = "5362bdb6-ce3e-4d0d-9a5b-3eb92c8aab38",
 *                 },
 *             },
 *             DefaultMaximumExpirationTimeInDays = 10,
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerConfiguration(ctx, "partnerConfiguration", &eventgrid.PartnerConfigurationArgs{
 * 			PartnerAuthorization: eventgrid.PartnerAuthorizationResponse{
 * 				AuthorizedPartnersList: eventgrid.PartnerArray{
 * 					&eventgrid.PartnerArgs{
 * 						AuthorizationExpirationTimeInUtc: pulumi.String("2022-01-28T01:20:55.142Z"),
 * 						PartnerName:                      pulumi.String("Contoso.Finance"),
 * 						PartnerRegistrationImmutableId:   pulumi.String("941892bc-f5d0-4d1c-8fb5-477570fc2b71"),
 * 					},
 * 					&eventgrid.PartnerArgs{
 * 						AuthorizationExpirationTimeInUtc: pulumi.String("2022-02-20T01:00:00.142Z"),
 * 						PartnerName:                      pulumi.String("fabrikam.HR"),
 * 						PartnerRegistrationImmutableId:   pulumi.String("5362bdb6-ce3e-4d0d-9a5b-3eb92c8aab38"),
 * 					},
 * 				},
 * 				DefaultMaximumExpirationTimeInDays: pulumi.Int(10),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerConfiguration;
 * import com.pulumi.azurenative.eventgrid.PartnerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerConfiguration = new PartnerConfiguration("partnerConfiguration", PartnerConfigurationArgs.builder()
 *             .partnerAuthorization(Map.ofEntries(
 *                 Map.entry("authorizedPartnersList",
 *                     Map.ofEntries(
 *                         Map.entry("authorizationExpirationTimeInUtc", "2022-01-28T01:20:55.142Z"),
 *                         Map.entry("partnerName", "Contoso.Finance"),
 *                         Map.entry("partnerRegistrationImmutableId", "941892bc-f5d0-4d1c-8fb5-477570fc2b71")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("authorizationExpirationTimeInUtc", "2022-02-20T01:00:00.142Z"),
 *                         Map.entry("partnerName", "fabrikam.HR"),
 *                         Map.entry("partnerRegistrationImmutableId", "5362bdb6-ce3e-4d0d-9a5b-3eb92c8aab38")
 *                     )),
 *                 Map.entry("defaultMaximumExpirationTimeInDays", 10)
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerConfiguration default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerConfigurations/default
 * ```
 * @property location Location of the resource.
 * @property partnerAuthorization The details of authorized partners.
 * @property provisioningState Provisioning state of the partner configuration.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property tags Tags of the resource.
 */
public data class PartnerConfigurationArgs(
    public val location: Output<String>? = null,
    public val partnerAuthorization: Output<PartnerAuthorizationArgs>? = null,
    public val provisioningState: Output<Either<String, PartnerConfigurationProvisioningState>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PartnerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PartnerConfigurationArgs =
        com.pulumi.azurenative.eventgrid.PartnerConfigurationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .partnerAuthorization(
                partnerAuthorization?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PartnerConfigurationArgs].
 */
@PulumiTagMarker
public class PartnerConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var partnerAuthorization: Output<PartnerAuthorizationArgs>? = null

    private var provisioningState: Output<Either<String, PartnerConfigurationProvisioningState>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Location of the resource.
     */
    @JvmName("qunfudclmedabsgr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The details of authorized partners.
     */
    @JvmName("vcgbrbjmytbpkurk")
    public suspend fun partnerAuthorization(`value`: Output<PartnerAuthorizationArgs>) {
        this.partnerAuthorization = value
    }

    /**
     * @param value Provisioning state of the partner configuration.
     */
    @JvmName("gljdovjwjpovcbec")
    public suspend
    fun provisioningState(`value`: Output<Either<String, PartnerConfigurationProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("qfgaktjkqpmblllc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("uhbosycnetxicpye")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("nurolklkgkrpwfhq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The details of authorized partners.
     */
    @JvmName("bujjwwrjkeiwpxiu")
    public suspend fun partnerAuthorization(`value`: PartnerAuthorizationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerAuthorization = mapped
    }

    /**
     * @param argument The details of authorized partners.
     */
    @JvmName("qgtupulmorbpoplr")
    public suspend
    fun partnerAuthorization(argument: suspend PartnerAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = PartnerAuthorizationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.partnerAuthorization = mapped
    }

    /**
     * @param value Provisioning state of the partner configuration.
     */
    @JvmName("bbpmwwbcdfjiqsbk")
    public suspend
    fun provisioningState(`value`: Either<String, PartnerConfigurationProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the partner configuration.
     */
    @JvmName("nrmbmdokjslstqja")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PartnerConfigurationProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the partner configuration.
     */
    @JvmName("qwavoxhuydggiimy")
    public fun provisioningState(`value`: PartnerConfigurationProvisioningState) {
        val toBeMapped = Either.ofRight<String, PartnerConfigurationProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("eytukjpppxcreftk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("jfaqyodkjaddnljv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("jxhjsutfuypxpbpt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PartnerConfigurationArgs = PartnerConfigurationArgs(
        location = location,
        partnerAuthorization = partnerAuthorization,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
