@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.TopicSpaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Topic space resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### TopicSpaces_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var topicSpace = new AzureNative.EventGrid.TopicSpace("topicSpace", new()
 *     {
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *         TopicSpaceName = "exampleTopicSpaceName1",
 *         TopicTemplates = new[]
 *         {
 *             "filter1",
 *             "filter2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewTopicSpace(ctx, "topicSpace", &eventgrid.TopicSpaceArgs{
 * 			NamespaceName:     pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			TopicSpaceName:    pulumi.String("exampleTopicSpaceName1"),
 * 			TopicTemplates: pulumi.StringArray{
 * 				pulumi.String("filter1"),
 * 				pulumi.String("filter2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.TopicSpace;
 * import com.pulumi.azurenative.eventgrid.TopicSpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var topicSpace = new TopicSpace("topicSpace", TopicSpaceArgs.builder()
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .topicSpaceName("exampleTopicSpaceName1")
 *             .topicTemplates(
 *                 "filter1",
 *                 "filter2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:TopicSpace exampleTopicSpaceName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topicSpaces/{topicSpaceName}
 * ```
 * @property description Description for the Topic Space resource.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicSpaceName The topic space name.
 * @property topicTemplates The topic filters in the topic space.
 * Example: "topicTemplates": [
 *               "devices/foo/bar",
 *               "devices/topic1/+",
 *               "devices/${principal.name}/${principal.attributes.keyName}" ].
 */
public data class TopicSpaceArgs(
    public val description: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topicSpaceName: Output<String>? = null,
    public val topicTemplates: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.TopicSpaceArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.TopicSpaceArgs =
        com.pulumi.azurenative.eventgrid.TopicSpaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topicSpaceName(topicSpaceName?.applyValue({ args0 -> args0 }))
            .topicTemplates(topicTemplates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TopicSpaceArgs].
 */
@PulumiTagMarker
public class TopicSpaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var topicSpaceName: Output<String>? = null

    private var topicTemplates: Output<List<String>>? = null

    /**
     * @param value Description for the Topic Space resource.
     */
    @JvmName("tyhtepcydmcunqyu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("tyfhltlgqiobkcuf")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("dvepqsmffhddhvik")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The topic space name.
     */
    @JvmName("mspdtcuyiyclusno")
    public suspend fun topicSpaceName(`value`: Output<String>) {
        this.topicSpaceName = value
    }

    /**
     * @param value The topic filters in the topic space.
     * Example: "topicTemplates": [
     *               "devices/foo/bar",
     *               "devices/topic1/+",
     *               "devices/${principal.name}/${principal.attributes.keyName}" ].
     */
    @JvmName("nddfnyigkkssrdew")
    public suspend fun topicTemplates(`value`: Output<List<String>>) {
        this.topicTemplates = value
    }

    @JvmName("cjwdoybmdohginue")
    public suspend fun topicTemplates(vararg values: Output<String>) {
        this.topicTemplates = Output.all(values.asList())
    }

    /**
     * @param values The topic filters in the topic space.
     * Example: "topicTemplates": [
     *               "devices/foo/bar",
     *               "devices/topic1/+",
     *               "devices/${principal.name}/${principal.attributes.keyName}" ].
     */
    @JvmName("qmfapvjqkyecfsgo")
    public suspend fun topicTemplates(values: List<Output<String>>) {
        this.topicTemplates = Output.all(values)
    }

    /**
     * @param value Description for the Topic Space resource.
     */
    @JvmName("jcvqkfhgdqvjiloj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("rkswenphabkxssle")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ibivkfmwuusyurfq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The topic space name.
     */
    @JvmName("atnkpxeofqxubvmc")
    public suspend fun topicSpaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicSpaceName = mapped
    }

    /**
     * @param value The topic filters in the topic space.
     * Example: "topicTemplates": [
     *               "devices/foo/bar",
     *               "devices/topic1/+",
     *               "devices/${principal.name}/${principal.attributes.keyName}" ].
     */
    @JvmName("ajigtourmtbtwdwh")
    public suspend fun topicTemplates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicTemplates = mapped
    }

    /**
     * @param values The topic filters in the topic space.
     * Example: "topicTemplates": [
     *               "devices/foo/bar",
     *               "devices/topic1/+",
     *               "devices/${principal.name}/${principal.attributes.keyName}" ].
     */
    @JvmName("ctrlmfqinrqychjp")
    public suspend fun topicTemplates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicTemplates = mapped
    }

    internal fun build(): TopicSpaceArgs = TopicSpaceArgs(
        description = description,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        topicSpaceName = topicSpaceName,
        topicTemplates = topicTemplates,
    )
}
