@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
 */
public enum class ClientCertificateValidationScheme(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme> {
    SubjectMatchesAuthenticationName(com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme.SubjectMatchesAuthenticationName),
    DnsMatchesAuthenticationName(com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme.DnsMatchesAuthenticationName),
    UriMatchesAuthenticationName(com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme.UriMatchesAuthenticationName),
    IpMatchesAuthenticationName(com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme.IpMatchesAuthenticationName),
    EmailMatchesAuthenticationName(com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme.EmailMatchesAuthenticationName),
    ThumbprintMatch(com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme.ThumbprintMatch),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.ClientCertificateValidationScheme):
            ClientCertificateValidationScheme =
            ClientCertificateValidationScheme.values().first { it.javaValue == javaType }
    }
}
