@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines the format that Event Grid should expect for incoming events published to the topic.
 */
public enum class InputSchema(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.InputSchema,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.InputSchema> {
    EventGridSchema(com.pulumi.azurenative.eventgrid.enums.InputSchema.EventGridSchema),
    CustomEventSchema(com.pulumi.azurenative.eventgrid.enums.InputSchema.CustomEventSchema),
    CloudEventSchemaV1_0(com.pulumi.azurenative.eventgrid.enums.InputSchema.CloudEventSchemaV1_0),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.InputSchema = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.InputSchema): InputSchema =
            InputSchema.values().first { it.javaValue == javaType }
    }
}
