@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ClientCertificateAuthenticationArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.ClientCertificateValidationScheme
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The certificate authentication properties for the client.
 * @property allowedThumbprints The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
 * @property validationScheme The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
 */
public data class ClientCertificateAuthenticationArgs(
    public val allowedThumbprints: Output<List<String>>? = null,
    public val validationScheme: Output<Either<String, ClientCertificateValidationScheme>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ClientCertificateAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.ClientCertificateAuthenticationArgs =
        com.pulumi.azurenative.eventgrid.inputs.ClientCertificateAuthenticationArgs.builder()
            .allowedThumbprints(allowedThumbprints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .validationScheme(
                validationScheme?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [ClientCertificateAuthenticationArgs].
 */
@PulumiTagMarker
public class ClientCertificateAuthenticationArgsBuilder internal constructor() {
    private var allowedThumbprints: Output<List<String>>? = null

    private var validationScheme: Output<Either<String, ClientCertificateValidationScheme>>? = null

    /**
     * @param value The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
     */
    @JvmName("vcljtgfrmgjxwdvk")
    public suspend fun allowedThumbprints(`value`: Output<List<String>>) {
        this.allowedThumbprints = value
    }

    @JvmName("qlogkgrxttkthbcs")
    public suspend fun allowedThumbprints(vararg values: Output<String>) {
        this.allowedThumbprints = Output.all(values.asList())
    }

    /**
     * @param values The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
     */
    @JvmName("neoturgvqcveapcd")
    public suspend fun allowedThumbprints(values: List<Output<String>>) {
        this.allowedThumbprints = Output.all(values)
    }

    /**
     * @param value The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
     */
    @JvmName("vslehutgurkvchbi")
    public suspend
    fun validationScheme(`value`: Output<Either<String, ClientCertificateValidationScheme>>) {
        this.validationScheme = value
    }

    /**
     * @param value The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
     */
    @JvmName("iosmqntmunsmfcdj")
    public suspend fun allowedThumbprints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedThumbprints = mapped
    }

    /**
     * @param values The list of thumbprints that are allowed during client authentication. This property is required only if the validationScheme is 'ThumbprintMatch'.
     */
    @JvmName("bleylkwkkihrfmwd")
    public suspend fun allowedThumbprints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedThumbprints = mapped
    }

    /**
     * @param value The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
     */
    @JvmName("oscysgqpjklvxppn")
    public suspend fun validationScheme(`value`: Either<String, ClientCertificateValidationScheme>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationScheme = mapped
    }

    /**
     * @param value The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
     */
    @JvmName("ywopojunuovycmse")
    public fun validationScheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClientCertificateValidationScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationScheme = mapped
    }

    /**
     * @param value The validation scheme used to authenticate the client. Default value is SubjectMatchesAuthenticationName.
     */
    @JvmName("atslehkxwiheueyh")
    public fun validationScheme(`value`: ClientCertificateValidationScheme) {
        val toBeMapped = Either.ofRight<String, ClientCertificateValidationScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validationScheme = mapped
    }

    internal fun build(): ClientCertificateAuthenticationArgs = ClientCertificateAuthenticationArgs(
        allowedThumbprints = allowedThumbprints,
        validationScheme = validationScheme,
    )
}
