@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.DeadLetterWithResourceIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Information about the deadletter destination with resource identity.
 * @property deadLetterDestination Information about the destination where events have to be delivered for the event subscription.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property identity The identity to use when dead-lettering events.
 */
public data class DeadLetterWithResourceIdentityArgs(
    public val deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null,
    public val identity: Output<EventSubscriptionIdentityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.DeadLetterWithResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.DeadLetterWithResourceIdentityArgs =
        com.pulumi.azurenative.eventgrid.inputs.DeadLetterWithResourceIdentityArgs.builder()
            .deadLetterDestination(
                deadLetterDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeadLetterWithResourceIdentityArgs].
 */
@PulumiTagMarker
public class DeadLetterWithResourceIdentityArgsBuilder internal constructor() {
    private var deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null

    private var identity: Output<EventSubscriptionIdentityArgs>? = null

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("pxykulmwjfyeinnb")
    public suspend fun deadLetterDestination(`value`: Output<StorageBlobDeadLetterDestinationArgs>) {
        this.deadLetterDestination = value
    }

    /**
     * @param value The identity to use when dead-lettering events.
     */
    @JvmName("bivuqrhjiyhocdcf")
    public suspend fun identity(`value`: Output<EventSubscriptionIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("odmkpsbtvpconctm")
    public suspend fun deadLetterDestination(`value`: StorageBlobDeadLetterDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterDestination = mapped
    }

    /**
     * @param argument Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("naetumatedtpwmox")
    public suspend
    fun deadLetterDestination(argument: suspend StorageBlobDeadLetterDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageBlobDeadLetterDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deadLetterDestination = mapped
    }

    /**
     * @param value The identity to use when dead-lettering events.
     */
    @JvmName("yiiynccyotehgaki")
    public suspend fun identity(`value`: EventSubscriptionIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity to use when dead-lettering events.
     */
    @JvmName("orumxtdfjyakbnfd")
    public suspend fun identity(argument: suspend EventSubscriptionIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EventSubscriptionIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    internal fun build(): DeadLetterWithResourceIdentityArgs = DeadLetterWithResourceIdentityArgs(
        deadLetterDestination = deadLetterDestination,
        identity = identity,
    )
}
