@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.DeliveryConfigurationArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.DeliveryMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the delivery configuration information of the event subscription.
 * @property deliveryMode Delivery mode of the event subscription.
 * @property queue This property should be populated when deliveryMode is queue and represents information about the queue subscription.
 */
public data class DeliveryConfigurationArgs(
    public val deliveryMode: Output<Either<String, DeliveryMode>>? = null,
    public val queue: Output<QueueInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.DeliveryConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.DeliveryConfigurationArgs =
        com.pulumi.azurenative.eventgrid.inputs.DeliveryConfigurationArgs.builder()
            .deliveryMode(
                deliveryMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .queue(queue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeliveryConfigurationArgs].
 */
@PulumiTagMarker
public class DeliveryConfigurationArgsBuilder internal constructor() {
    private var deliveryMode: Output<Either<String, DeliveryMode>>? = null

    private var queue: Output<QueueInfoArgs>? = null

    /**
     * @param value Delivery mode of the event subscription.
     */
    @JvmName("iiiiqbkyxayxqjpa")
    public suspend fun deliveryMode(`value`: Output<Either<String, DeliveryMode>>) {
        this.deliveryMode = value
    }

    /**
     * @param value This property should be populated when deliveryMode is queue and represents information about the queue subscription.
     */
    @JvmName("grvyahlmnipkxflc")
    public suspend fun queue(`value`: Output<QueueInfoArgs>) {
        this.queue = value
    }

    /**
     * @param value Delivery mode of the event subscription.
     */
    @JvmName("wqrnfqyofnrjnoqn")
    public suspend fun deliveryMode(`value`: Either<String, DeliveryMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryMode = mapped
    }

    /**
     * @param value Delivery mode of the event subscription.
     */
    @JvmName("eiuaogwomwbhuslu")
    public fun deliveryMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeliveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryMode = mapped
    }

    /**
     * @param value Delivery mode of the event subscription.
     */
    @JvmName("xdeovxcjvttkofyr")
    public fun deliveryMode(`value`: DeliveryMode) {
        val toBeMapped = Either.ofRight<String, DeliveryMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryMode = mapped
    }

    /**
     * @param value This property should be populated when deliveryMode is queue and represents information about the queue subscription.
     */
    @JvmName("cusviyvruqxxeyys")
    public suspend fun queue(`value`: QueueInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queue = mapped
    }

    /**
     * @param argument This property should be populated when deliveryMode is queue and represents information about the queue subscription.
     */
    @JvmName("gmgomqtcafgbowia")
    public suspend fun queue(argument: suspend QueueInfoArgsBuilder.() -> Unit) {
        val toBeMapped = QueueInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.queue = mapped
    }

    internal fun build(): DeliveryConfigurationArgs = DeliveryConfigurationArgs(
        deliveryMode = deliveryMode,
        queue = queue,
    )
}
