@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.DynamicDeliveryAttributeMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dynamic delivery attribute mapping details.
 * @property name Name of the delivery attribute or header.
 * @property sourceField JSON path in the event which contains attribute value.
 * @property type Type of the delivery attribute or header name.
 * Expected value is 'Dynamic'.
 */
public data class DynamicDeliveryAttributeMappingArgs(
    public val name: Output<String>? = null,
    public val sourceField: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.DynamicDeliveryAttributeMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.DynamicDeliveryAttributeMappingArgs =
        com.pulumi.azurenative.eventgrid.inputs.DynamicDeliveryAttributeMappingArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceField(sourceField?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DynamicDeliveryAttributeMappingArgs].
 */
@PulumiTagMarker
public class DynamicDeliveryAttributeMappingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceField: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of the delivery attribute or header.
     */
    @JvmName("uklccwjsndbrleyi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value JSON path in the event which contains attribute value.
     */
    @JvmName("hqkprdbhoanlokyk")
    public suspend fun sourceField(`value`: Output<String>) {
        this.sourceField = value
    }

    /**
     * @param value Type of the delivery attribute or header name.
     * Expected value is 'Dynamic'.
     */
    @JvmName("tlnqvqbtygybsypr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of the delivery attribute or header.
     */
    @JvmName("onplwymdimknpmtl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value JSON path in the event which contains attribute value.
     */
    @JvmName("hivfeuvwaysjwqpa")
    public suspend fun sourceField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceField = mapped
    }

    /**
     * @param value Type of the delivery attribute or header name.
     * Expected value is 'Dynamic'.
     */
    @JvmName("hdvpsbwtgqrvfivv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DynamicDeliveryAttributeMappingArgs = DynamicDeliveryAttributeMappingArgs(
        name = name,
        sourceField = sourceField,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
