@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.DynamicRoutingEnrichmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Dynamic routing enrichment key.
 * @property value Dynamic routing enrichment value.
 */
public data class DynamicRoutingEnrichmentArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.DynamicRoutingEnrichmentArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.DynamicRoutingEnrichmentArgs =
        com.pulumi.azurenative.eventgrid.inputs.DynamicRoutingEnrichmentArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DynamicRoutingEnrichmentArgs].
 */
@PulumiTagMarker
public class DynamicRoutingEnrichmentArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Dynamic routing enrichment key.
     */
    @JvmName("qgdpgyyswxnmkfju")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Dynamic routing enrichment value.
     */
    @JvmName("pyxhqvmobbjomfct")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Dynamic routing enrichment key.
     */
    @JvmName("rntvcdrsbbmmyjib")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Dynamic routing enrichment value.
     */
    @JvmName("pmdaomhnpntqqblk")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): DynamicRoutingEnrichmentArgs = DynamicRoutingEnrichmentArgs(
        key = key,
        `value` = `value`,
    )
}
