@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.EventHubEventSubscriptionDestinationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Information about the event hub destination for an event subscription.
 * @property deliveryAttributeMappings Delivery attribute details.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'EventHub'.
 * @property resourceId The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
 */
public data class EventHubEventSubscriptionDestinationArgs(
    public val deliveryAttributeMappings:
    Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>? =
        null,
    public val endpointType: Output<String>,
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.EventHubEventSubscriptionDestinationArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.EventHubEventSubscriptionDestinationArgs =
        com.pulumi.azurenative.eventgrid.inputs.EventHubEventSubscriptionDestinationArgs.builder()
            .deliveryAttributeMappings(
                deliveryAttributeMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubEventSubscriptionDestinationArgs].
 */
@PulumiTagMarker
public class EventHubEventSubscriptionDestinationArgsBuilder internal constructor() {
    private var deliveryAttributeMappings:
        Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>? =
        null

    private var endpointType: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Delivery attribute details.
     */
    @JvmName("hkjpilfjsiembrwc")
    public suspend
    fun deliveryAttributeMappings(`value`: Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>) {
        this.deliveryAttributeMappings = value
    }

    @JvmName("sgexnaelpkbxovmi")
    public suspend fun deliveryAttributeMappings(
        vararg
        values: Output<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>,
    ) {
        this.deliveryAttributeMappings = Output.all(values.asList())
    }

    /**
     * @param values Delivery attribute details.
     */
    @JvmName("favlxamifghtggca")
    public suspend
    fun deliveryAttributeMappings(values: List<Output<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>) {
        this.deliveryAttributeMappings = Output.all(values)
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'EventHub'.
     */
    @JvmName("fgdyhussorcgjmtx")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
     */
    @JvmName("xrspkpdwlpistjlu")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Delivery attribute details.
     */
    @JvmName("xtxkfmgruashqicd")
    public suspend
    fun deliveryAttributeMappings(`value`: List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryAttributeMappings = mapped
    }

    /**
     * @param values Delivery attribute details.
     */
    @JvmName("hyyfgxnnklhhqekv")
    public suspend fun deliveryAttributeMappings(
        vararg
        values: Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryAttributeMappings = mapped
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'EventHub'.
     */
    @JvmName("cnvmufdycidpqsea")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The Azure Resource Id that represents the endpoint of an Event Hub destination of an event subscription.
     */
    @JvmName("rxeyotsynnbryigc")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): EventHubEventSubscriptionDestinationArgs =
        EventHubEventSubscriptionDestinationArgs(
            deliveryAttributeMappings = deliveryAttributeMappings,
            endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
            resourceId = resourceId,
        )
}
