@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filter for the Event Subscription.
 * @property advancedFilters An array of advanced filters that are used for filtering event subscriptions.
 * @property enableAdvancedFilteringOnArrays Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
 * @property includedEventTypes A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
 * @property isSubjectCaseSensitive Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
 * should be compared in a case sensitive manner.
 * @property subjectBeginsWith An optional string to filter events for an event subscription based on a resource path prefix.
 * The format of this depends on the publisher of the events.
 * Wildcard characters are not supported in this path.
 * @property subjectEndsWith An optional string to filter events for an event subscription based on a resource path suffix.
 * Wildcard characters are not supported in this path.
 */
public data class EventSubscriptionFilterArgs(
    public val advancedFilters: Output<List<Any>>? = null,
    public val enableAdvancedFilteringOnArrays: Output<Boolean>? = null,
    public val includedEventTypes: Output<List<String>>? = null,
    public val isSubjectCaseSensitive: Output<Boolean>? = null,
    public val subjectBeginsWith: Output<String>? = null,
    public val subjectEndsWith: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.EventSubscriptionFilterArgs.builder()
            .advancedFilters(advancedFilters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enableAdvancedFilteringOnArrays(enableAdvancedFilteringOnArrays?.applyValue({ args0 -> args0 }))
            .includedEventTypes(includedEventTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isSubjectCaseSensitive(isSubjectCaseSensitive?.applyValue({ args0 -> args0 }))
            .subjectBeginsWith(subjectBeginsWith?.applyValue({ args0 -> args0 }))
            .subjectEndsWith(subjectEndsWith?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSubscriptionFilterArgs].
 */
@PulumiTagMarker
public class EventSubscriptionFilterArgsBuilder internal constructor() {
    private var advancedFilters: Output<List<Any>>? = null

    private var enableAdvancedFilteringOnArrays: Output<Boolean>? = null

    private var includedEventTypes: Output<List<String>>? = null

    private var isSubjectCaseSensitive: Output<Boolean>? = null

    private var subjectBeginsWith: Output<String>? = null

    private var subjectEndsWith: Output<String>? = null

    /**
     * @param value An array of advanced filters that are used for filtering event subscriptions.
     */
    @JvmName("cctuevxqfcweobhr")
    public suspend fun advancedFilters(`value`: Output<List<Any>>) {
        this.advancedFilters = value
    }

    @JvmName("borskhhalfxxoalg")
    public suspend fun advancedFilters(vararg values: Output<Any>) {
        this.advancedFilters = Output.all(values.asList())
    }

    /**
     * @param values An array of advanced filters that are used for filtering event subscriptions.
     */
    @JvmName("vtecqwmlckttjssf")
    public suspend fun advancedFilters(values: List<Output<Any>>) {
        this.advancedFilters = Output.all(values)
    }

    /**
     * @param value Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
     */
    @JvmName("bljckqncfjahsgqi")
    public suspend fun enableAdvancedFilteringOnArrays(`value`: Output<Boolean>) {
        this.enableAdvancedFilteringOnArrays = value
    }

    /**
     * @param value A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("pnjifqhfmcfeophc")
    public suspend fun includedEventTypes(`value`: Output<List<String>>) {
        this.includedEventTypes = value
    }

    @JvmName("vpgluepxlkncfkmb")
    public suspend fun includedEventTypes(vararg values: Output<String>) {
        this.includedEventTypes = Output.all(values.asList())
    }

    /**
     * @param values A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("syccemkjipkvhupw")
    public suspend fun includedEventTypes(values: List<Output<String>>) {
        this.includedEventTypes = Output.all(values)
    }

    /**
     * @param value Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
     * should be compared in a case sensitive manner.
     */
    @JvmName("ejvorppkirandebn")
    public suspend fun isSubjectCaseSensitive(`value`: Output<Boolean>) {
        this.isSubjectCaseSensitive = value
    }

    /**
     * @param value An optional string to filter events for an event subscription based on a resource path prefix.
     * The format of this depends on the publisher of the events.
     * Wildcard characters are not supported in this path.
     */
    @JvmName("behhbecrprcxprtw")
    public suspend fun subjectBeginsWith(`value`: Output<String>) {
        this.subjectBeginsWith = value
    }

    /**
     * @param value An optional string to filter events for an event subscription based on a resource path suffix.
     * Wildcard characters are not supported in this path.
     */
    @JvmName("exdmcecvuucwppcx")
    public suspend fun subjectEndsWith(`value`: Output<String>) {
        this.subjectEndsWith = value
    }

    /**
     * @param value An array of advanced filters that are used for filtering event subscriptions.
     */
    @JvmName("rssxjnbjgorusevx")
    public suspend fun advancedFilters(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedFilters = mapped
    }

    /**
     * @param values An array of advanced filters that are used for filtering event subscriptions.
     */
    @JvmName("ynnuusljhaaqgsvo")
    public suspend fun advancedFilters(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedFilters = mapped
    }

    /**
     * @param value Allows advanced filters to be evaluated against an array of values instead of expecting a singular value.
     */
    @JvmName("yusdfmcnejnwbjnn")
    public suspend fun enableAdvancedFilteringOnArrays(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAdvancedFilteringOnArrays = mapped
    }

    /**
     * @param value A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("fqpywboeieifbcsq")
    public suspend fun includedEventTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedEventTypes = mapped
    }

    /**
     * @param values A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
     */
    @JvmName("jqtccdfmplvwmtjq")
    public suspend fun includedEventTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedEventTypes = mapped
    }

    /**
     * @param value Specifies if the SubjectBeginsWith and SubjectEndsWith properties of the filter
     * should be compared in a case sensitive manner.
     */
    @JvmName("cudbbgnebccurxvn")
    public suspend fun isSubjectCaseSensitive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSubjectCaseSensitive = mapped
    }

    /**
     * @param value An optional string to filter events for an event subscription based on a resource path prefix.
     * The format of this depends on the publisher of the events.
     * Wildcard characters are not supported in this path.
     */
    @JvmName("kmoufkltgiyxfief")
    public suspend fun subjectBeginsWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectBeginsWith = mapped
    }

    /**
     * @param value An optional string to filter events for an event subscription based on a resource path suffix.
     * Wildcard characters are not supported in this path.
     */
    @JvmName("hyokjanaunpgqnyq")
    public suspend fun subjectEndsWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectEndsWith = mapped
    }

    internal fun build(): EventSubscriptionFilterArgs = EventSubscriptionFilterArgs(
        advancedFilters = advancedFilters,
        enableAdvancedFilteringOnArrays = enableAdvancedFilteringOnArrays,
        includedEventTypes = includedEventTypes,
        isSubjectCaseSensitive = isSubjectCaseSensitive,
        subjectBeginsWith = subjectBeginsWith,
        subjectEndsWith = subjectEndsWith,
    )
}
