@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicEventSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName Name of the top level domain.
 * @property eventSubscriptionName Name of the event subscription.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the domain topic.
 */
public data class GetDomainTopicEventSubscriptionPlainArgs(
    public val domainName: String,
    public val eventSubscriptionName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicEventSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicEventSubscriptionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetDomainTopicEventSubscriptionPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainTopicEventSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetDomainTopicEventSubscriptionPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var eventSubscriptionName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value Name of the top level domain.
     */
    @JvmName("oideedfjvxfduehx")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Name of the event subscription.
     */
    @JvmName("xywxvbguucwfdssd")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ffwodgifqipbqaof")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the domain topic.
     */
    @JvmName("jrvuwefpojwublda")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetDomainTopicEventSubscriptionPlainArgs =
        GetDomainTopicEventSubscriptionPlainArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            topicName = topicName ?: throw PulumiNullFieldException("topicName"),
        )
}
