@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the namespace topic.
 */
public data class GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs(
    public val eventSubscriptionName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs].
 */
@PulumiTagMarker
public class GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgsBuilder internal
constructor() {
    private var eventSubscriptionName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value Name of the event subscription to be created. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("osjdfbkilvddtvya")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("akbshaadnoumqrgw")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("myjcajupbcmdadvh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("ydcgkpijwxqrswar")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs =
        GetNamespaceTopicEventSubscriptionDeliveryAttributesPlainArgs(
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            topicName = topicName ?: throw PulumiNullFieldException("topicName"),
        )
}
