@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the namespace topic.
 */
public data class GetNamespaceTopicPlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetNamespaceTopicPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNamespaceTopicPlainArgs].
 */
@PulumiTagMarker
public class GetNamespaceTopicPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var topicName: String? = null

    /**
     * @param value Name of the namespace.
     */
    @JvmName("hdacnxpavvfcjuqo")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("tlaurlcwmhugvcqe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("wqsepacvlcwklrxp")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetNamespaceTopicPlainArgs = GetNamespaceTopicPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
