@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPermissionBindingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName Name of the namespace.
 * @property permissionBindingName Name of the permission binding.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPermissionBindingPlainArgs(
    public val namespaceName: String,
    public val permissionBindingName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPermissionBindingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetPermissionBindingPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPermissionBindingPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .permissionBindingName(permissionBindingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPermissionBindingPlainArgs].
 */
@PulumiTagMarker
public class GetPermissionBindingPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var permissionBindingName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the namespace.
     */
    @JvmName("xtfsdxqpylwjppmh")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the permission binding.
     */
    @JvmName("xmmxnyvtukrejwbb")
    public suspend fun permissionBindingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.permissionBindingName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("exhpuusgymrscuib")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPermissionBindingPlainArgs = GetPermissionBindingPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        permissionBindingName = permissionBindingName ?: throw
            PulumiNullFieldException("permissionBindingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
