@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property parentName The name of the parent resource (namely, either, the topic name, domain name, or partner namespace name).
 * @property parentType The type of the parent resource. This can be either \'topics\', \'domains\', or \'partnerNamespaces\'.
 * @property privateEndpointConnectionName The name of the private endpoint connection connection.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val parentName: String,
    public val parentType: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .parentName(parentName.let({ args0 -> args0 }))
            .parentType(parentType.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var parentName: String? = null

    private var parentType: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the parent resource (namely, either, the topic name, domain name, or partner namespace name).
     */
    @JvmName("rdftdewretupxknl")
    public suspend fun parentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentName = mapped
    }

    /**
     * @param value The type of the parent resource. This can be either \'topics\', \'domains\', or \'partnerNamespaces\'.
     */
    @JvmName("xuiriirbuyyilcce")
    public suspend fun parentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.parentType = mapped
    }

    /**
     * @param value The name of the private endpoint connection connection.
     */
    @JvmName("uiifqjnwqsfinpar")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ifvuwqmbkgfuyabd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            parentName = parentName ?: throw PulumiNullFieldException("parentName"),
            parentType = parentType ?: throw PulumiNullFieldException("parentType"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
