@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetTopicSpacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicSpaceName Name of the Topic space.
 */
public data class GetTopicSpacePlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val topicSpaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetTopicSpacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetTopicSpacePlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetTopicSpacePlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .topicSpaceName(topicSpaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTopicSpacePlainArgs].
 */
@PulumiTagMarker
public class GetTopicSpacePlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var topicSpaceName: String? = null

    /**
     * @param value Name of the namespace.
     */
    @JvmName("skcmxiddpcjrrmqj")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("edpsdehbbjugsoxh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Topic space.
     */
    @JvmName("qpemdieyqsuiunrw")
    public suspend fun topicSpaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicSpaceName = mapped
    }

    internal fun build(): GetTopicSpacePlainArgs = GetTopicSpacePlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        topicSpaceName = topicSpaceName ?: throw PulumiNullFieldException("topicSpaceName"),
    )
}
