@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.IpActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to perform based on the match or no match of the IpMask.
 * @property ipMask IP Address in CIDR notation e.g., 10.0.0.0/8.
 */
public data class InboundIpRuleArgs(
    public val action: Output<Either<String, IpActionType>>? = null,
    public val ipMask: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs =
        com.pulumi.azurenative.eventgrid.inputs.InboundIpRuleArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipMask(ipMask?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InboundIpRuleArgs].
 */
@PulumiTagMarker
public class InboundIpRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, IpActionType>>? = null

    private var ipMask: Output<String>? = null

    /**
     * @param value Action to perform based on the match or no match of the IpMask.
     */
    @JvmName("tgtwnwrnknkroyoe")
    public suspend fun action(`value`: Output<Either<String, IpActionType>>) {
        this.action = value
    }

    /**
     * @param value IP Address in CIDR notation e.g., 10.0.0.0/8.
     */
    @JvmName("fcgbxuirrlqknpef")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value Action to perform based on the match or no match of the IpMask.
     */
    @JvmName("gngfwwdjkqljmlhx")
    public suspend fun action(`value`: Either<String, IpActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to perform based on the match or no match of the IpMask.
     */
    @JvmName("vxjaybuhqhlglsdb")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to perform based on the match or no match of the IpMask.
     */
    @JvmName("gwgeouewhkrpuedk")
    public fun action(`value`: IpActionType) {
        val toBeMapped = Either.ofRight<String, IpActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP Address in CIDR notation e.g., 10.0.0.0/8.
     */
    @JvmName("eukxonrtwcxmjivu")
    public suspend fun ipMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    internal fun build(): InboundIpRuleArgs = InboundIpRuleArgs(
        action = action,
        ipMask = ipMask,
    )
}
