@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.NamespaceSkuArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents available Sku pricing tiers.
 * @property capacity Specifies the number of Throughput Units that defines the capacity for the namespace. The property default value is
 * 1 which signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace. Min capacity is 1 and
 * max allowed capacity is 20.
 * @property name The name of the SKU.
 */
public data class NamespaceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, SkuName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.NamespaceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.NamespaceSkuArgs =
        com.pulumi.azurenative.eventgrid.inputs.NamespaceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [NamespaceSkuArgs].
 */
@PulumiTagMarker
public class NamespaceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value Specifies the number of Throughput Units that defines the capacity for the namespace. The property default value is
     * 1 which signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace. Min capacity is 1 and
     * max allowed capacity is 20.
     */
    @JvmName("baucxhowunompvqu")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("cmetrgmkaldsxdkj")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value Specifies the number of Throughput Units that defines the capacity for the namespace. The property default value is
     * 1 which signifies 1 Throughput Unit = 1MB/s ingress and 2MB/s egress per namespace. Min capacity is 1 and
     * max allowed capacity is 20.
     */
    @JvmName("wlengmnkkypocfwv")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("iqyuluahjtmndywm")
    public suspend fun name(`value`: Either<String, SkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("xrowrakktevkwaso")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("etposqwuuahndohk")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): NamespaceSkuArgs = NamespaceSkuArgs(
        capacity = capacity,
        name = name,
    )
}
