@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.NumberInRangeFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NumberInRange Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberInRange'.
 * @property values The set of filter values.
 */
public data class NumberInRangeFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val values: Output<List<List<Double>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.NumberInRangeFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.NumberInRangeFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.NumberInRangeFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0.map({ args0 -> args0 }) }) })).build()
}

/**
 * Builder for [NumberInRangeFilterArgs].
 */
@PulumiTagMarker
public class NumberInRangeFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var values: Output<List<List<Double>>>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("ggsnanglaevdbmmh")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberInRange'.
     */
    @JvmName("eiemqkughsnuhixo")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("ddexiqthcajaijum")
    public suspend fun values(`value`: Output<List<List<Double>>>) {
        this.values = value
    }

    @JvmName("doyvorxoglnesudq")
    public suspend fun values(vararg values: Output<List<Double>>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("bedmngsopngudtwr")
    public suspend fun values(values: List<Output<List<Double>>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("wspsnypvkgwpryur")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberInRange'.
     */
    @JvmName("orckekmlaprqgwbm")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("msnpdirovnakuiyc")
    public suspend fun values(`value`: List<List<Double>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("rujkwspayhngqdgf")
    public suspend fun values(vararg values: List<Double>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): NumberInRangeFilterArgs = NumberInRangeFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        values = values,
    )
}
