@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.PartnerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the partner.
 * @property authorizationExpirationTimeInUtc Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or delete resources in subscriber's
 * context will fail. If specified, the allowed values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
 * If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration or 7 if this value is not specified.
 * @property partnerName The partner name.
 * @property partnerRegistrationImmutableId The immutableId of the corresponding partner registration.
 */
public data class PartnerArgs(
    public val authorizationExpirationTimeInUtc: Output<String>? = null,
    public val partnerName: Output<String>? = null,
    public val partnerRegistrationImmutableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.PartnerArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.PartnerArgs =
        com.pulumi.azurenative.eventgrid.inputs.PartnerArgs.builder()
            .authorizationExpirationTimeInUtc(authorizationExpirationTimeInUtc?.applyValue({ args0 -> args0 }))
            .partnerName(partnerName?.applyValue({ args0 -> args0 }))
            .partnerRegistrationImmutableId(
                partnerRegistrationImmutableId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [PartnerArgs].
 */
@PulumiTagMarker
public class PartnerArgsBuilder internal constructor() {
    private var authorizationExpirationTimeInUtc: Output<String>? = null

    private var partnerName: Output<String>? = null

    private var partnerRegistrationImmutableId: Output<String>? = null

    /**
     * @param value Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or delete resources in subscriber's
     * context will fail. If specified, the allowed values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
     * If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration or 7 if this value is not specified.
     */
    @JvmName("uhpdlhwjrxybmoss")
    public suspend fun authorizationExpirationTimeInUtc(`value`: Output<String>) {
        this.authorizationExpirationTimeInUtc = value
    }

    /**
     * @param value The partner name.
     */
    @JvmName("tfyiyffjocbvdegh")
    public suspend fun partnerName(`value`: Output<String>) {
        this.partnerName = value
    }

    /**
     * @param value The immutableId of the corresponding partner registration.
     */
    @JvmName("tuqeynlowgtrktln")
    public suspend fun partnerRegistrationImmutableId(`value`: Output<String>) {
        this.partnerRegistrationImmutableId = value
    }

    /**
     * @param value Expiration time of the partner authorization. If this timer expires, any request from this partner to create, update or delete resources in subscriber's
     * context will fail. If specified, the allowed values are between 1 to the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration.
     * If not specified, the default value will be the value of defaultMaximumExpirationTimeInDays specified in PartnerConfiguration or 7 if this value is not specified.
     */
    @JvmName("xvdljhtqqtyerjjt")
    public suspend fun authorizationExpirationTimeInUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationExpirationTimeInUtc = mapped
    }

    /**
     * @param value The partner name.
     */
    @JvmName("vjulnewhrsbdhfbd")
    public suspend fun partnerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerName = mapped
    }

    /**
     * @param value The immutableId of the corresponding partner registration.
     */
    @JvmName("nmwmewyhjvwkeqqq")
    public suspend fun partnerRegistrationImmutableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegistrationImmutableId = mapped
    }

    internal fun build(): PartnerArgs = PartnerArgs(
        authorizationExpirationTimeInUtc = authorizationExpirationTimeInUtc,
        partnerName = partnerName,
        partnerRegistrationImmutableId = partnerRegistrationImmutableId,
    )
}
