@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.ResourceProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groupIds GroupIds from the private link service resource.
 * @property privateEndpoint The Private Endpoint resource for this Connection.
 * @property privateLinkServiceConnectionState Details about the state of the connection.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 */
public data class PrivateEndpointConnectionArgs(
    public val groupIds: Output<List<String>>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, ResourceProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.eventgrid.inputs.PrivateEndpointConnectionArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, ResourceProvisioningState>>? = null

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("audkbyknxhrnbcqs")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("lryukxlexvacwwpt")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("yahgjybupyldqbhr")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("bxinydgocklnlnyp")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("tlhfwivgcxtmapos")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("njollldsjbelokdu")
    public suspend fun provisioningState(`value`: Output<Either<String, ResourceProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("vglqrgyegjslieug")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("ouedwcskfjiyxqxx")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("cvdywcdeuvjvqggv")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The Private Endpoint resource for this Connection.
     */
    @JvmName("brctcvvtpqlwyrul")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("hnuonmpyhpqujfsl")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Details about the state of the connection.
     */
    @JvmName("mnmuupxenvvoonpx")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("xrhplntwpuhmtcpp")
    public suspend fun provisioningState(`value`: Either<String, ResourceProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("vjaxqlpixrxjyqkr")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("lfrmuibsymkgptdw")
    public fun provisioningState(`value`: ResourceProvisioningState) {
        val toBeMapped = Either.ofRight<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        groupIds = groupIds,
        privateEndpoint = privateEndpoint,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
    )
}
