@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.StaticDeliveryAttributeMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Static delivery attribute mapping details.
 * @property isSecret Boolean flag to tell if the attribute contains sensitive information .
 * @property name Name of the delivery attribute or header.
 * @property type Type of the delivery attribute or header name.
 * Expected value is 'Static'.
 * @property value Value of the delivery attribute.
 */
public data class StaticDeliveryAttributeMappingArgs(
    public val isSecret: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val type: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.StaticDeliveryAttributeMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.StaticDeliveryAttributeMappingArgs =
        com.pulumi.azurenative.eventgrid.inputs.StaticDeliveryAttributeMappingArgs.builder()
            .isSecret(isSecret?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticDeliveryAttributeMappingArgs].
 */
@PulumiTagMarker
public class StaticDeliveryAttributeMappingArgsBuilder internal constructor() {
    private var isSecret: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Boolean flag to tell if the attribute contains sensitive information .
     */
    @JvmName("fgpvqrobycvqeepq")
    public suspend fun isSecret(`value`: Output<Boolean>) {
        this.isSecret = value
    }

    /**
     * @param value Name of the delivery attribute or header.
     */
    @JvmName("cpkrowfqapmwntvx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of the delivery attribute or header name.
     * Expected value is 'Static'.
     */
    @JvmName("ytstcbrawrskhcvn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Value of the delivery attribute.
     */
    @JvmName("dyvfbjasnxcfyiqa")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Boolean flag to tell if the attribute contains sensitive information .
     */
    @JvmName("vhtylsoxxhowljaj")
    public suspend fun isSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSecret = mapped
    }

    /**
     * @param value Name of the delivery attribute or header.
     */
    @JvmName("lcrxtlfndfavbmpx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of the delivery attribute or header name.
     * Expected value is 'Static'.
     */
    @JvmName("wqgxirsmjqiqksrq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of the delivery attribute.
     */
    @JvmName("cxhwwsdhnoqvoipp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): StaticDeliveryAttributeMappingArgs = StaticDeliveryAttributeMappingArgs(
        isSecret = isSecret,
        name = name,
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value`,
    )
}
