@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Event Subscription.
 * @property deliveryConfiguration Information about the delivery configuration of the event subscription.
 * @property eventDeliverySchema The event delivery schema for the event subscription.
 * @property filtersConfiguration Information about the filter for the event subscription.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the event subscription.
 * @property systemData The system metadata relating to Event Subscription resource.
 * @property type Type of the resource.
 */
public data class GetNamespaceTopicEventSubscriptionResult(
    public val deliveryConfiguration: DeliveryConfigurationResponse? = null,
    public val eventDeliverySchema: String? = null,
    public val filtersConfiguration: FiltersConfigurationResponse? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetNamespaceTopicEventSubscriptionResult):
            GetNamespaceTopicEventSubscriptionResult = GetNamespaceTopicEventSubscriptionResult(
            deliveryConfiguration = javaType.deliveryConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.DeliveryConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            eventDeliverySchema = javaType.eventDeliverySchema().map({ args0 -> args0 }).orElse(null),
            filtersConfiguration = javaType.filtersConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.FiltersConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
