@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Namespace topic details.
 * @property eventRetentionInDays Event retention for the namespace topic expressed in days. The property default value is 1 day.
 * Min event retention duration value is 1 day and max event retention duration value is 1 day.
 * @property id Fully qualified identifier of the resource.
 * @property inputSchema This determines the format that is expected for incoming events published to the topic.
 * @property name Name of the resource.
 * @property provisioningState Provisioning state of the namespace topic.
 * @property publisherType Publisher type of the namespace topic.
 * @property systemData The system metadata relating to namespace topic resource.
 * @property type Type of the resource.
 */
public data class GetNamespaceTopicResult(
    public val eventRetentionInDays: Int? = null,
    public val id: String,
    public val inputSchema: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val publisherType: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetNamespaceTopicResult):
            GetNamespaceTopicResult = GetNamespaceTopicResult(
            eventRetentionInDays = javaType.eventRetentionInDays().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            inputSchema = javaType.inputSchema().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publisherType = javaType.publisherType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
