@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Event Grid Partner Destination.
 * @property activationState Activation state of the partner destination.
 * @property endpointBaseUrl Endpoint Base URL of the partner destination
 * @property endpointServiceContext Endpoint context associated with this partner destination.
 * @property expirationTimeIfNotActivatedUtc Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
 * the partner destination and corresponding channel are deleted.
 * @property id Fully qualified identifier of the resource.
 * @property location Location of the resource.
 * @property messageForActivation Context or helpful message that can be used during the approval process.
 * @property name Name of the resource.
 * @property partnerRegistrationImmutableId The immutable Id of the corresponding partner registration.
 * @property provisioningState Provisioning state of the partner destination.
 * @property systemData The system metadata relating to Partner Destination resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetPartnerDestinationResult(
    public val activationState: String? = null,
    public val endpointBaseUrl: String? = null,
    public val endpointServiceContext: String? = null,
    public val expirationTimeIfNotActivatedUtc: String? = null,
    public val id: String,
    public val location: String,
    public val messageForActivation: String? = null,
    public val name: String,
    public val partnerRegistrationImmutableId: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPartnerDestinationResult):
            GetPartnerDestinationResult = GetPartnerDestinationResult(
            activationState = javaType.activationState().map({ args0 -> args0 }).orElse(null),
            endpointBaseUrl = javaType.endpointBaseUrl().map({ args0 -> args0 }).orElse(null),
            endpointServiceContext = javaType.endpointServiceContext().map({ args0 -> args0 }).orElse(null),
            expirationTimeIfNotActivatedUtc = javaType.expirationTimeIfNotActivatedUtc().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            messageForActivation = javaType.messageForActivation().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnerRegistrationImmutableId = javaType.partnerRegistrationImmutableId().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
