@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Permission binding resource.
 * @property clientGroupName The name of the client group resource that the permission is bound to.
 * The client group needs to be a resource under the same namespace the permission binding is a part of.
 * @property description Description for the Permission Binding resource.
 * @property id Fully qualified identifier of the resource.
 * @property name Name of the resource.
 * @property permission The allowed permission.
 * @property provisioningState Provisioning state of the PermissionBinding resource.
 * @property systemData The system metadata relating to the PermissionBinding resource.
 * @property topicSpaceName The name of the Topic Space resource that the permission is bound to.
 * The Topic space needs to be a resource under the same namespace the permission binding is a part of.
 * @property type Type of the resource.
 */
public data class GetPermissionBindingResult(
    public val clientGroupName: String? = null,
    public val description: String? = null,
    public val id: String,
    public val name: String,
    public val permission: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val topicSpaceName: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPermissionBindingResult):
            GetPermissionBindingResult = GetPermissionBindingResult(
            clientGroupName = javaType.clientGroupName().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            permission = javaType.permission().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topicSpaceName = javaType.topicSpaceName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
