@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Action to perform based on the match or no match of the IpMask.
 * @property ipMask IP Address in CIDR notation e.g., 10.0.0.0/8.
 */
public data class InboundIpRuleResponse(
    public val action: String? = null,
    public val ipMask: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.InboundIpRuleResponse):
            InboundIpRuleResponse = InboundIpRuleResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            ipMask = javaType.ipMask().map({ args0 -> args0 }).orElse(null),
        )
    }
}
