@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the storage blob based dead letter destination.
 * @property blobContainerName The name of the Storage blob container that is the destination of the deadletter events
 * @property endpointType Type of the endpoint for the dead letter destination
 * Expected value is 'StorageBlob'.
 * @property resourceId The Azure Resource ID of the storage account that is the destination of the deadletter events
 */
public data class StorageBlobDeadLetterDestinationResponse(
    public val blobContainerName: String? = null,
    public val endpointType: String,
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.StorageBlobDeadLetterDestinationResponse):
            StorageBlobDeadLetterDestinationResponse = StorageBlobDeadLetterDestinationResponse(
            blobContainerName = javaType.blobContainerName().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType(),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
