@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Information about the storage queue destination for an event subscription.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'StorageQueue'.
 * @property queueMessageTimeToLiveInSeconds Storage queue message time to live in seconds.
 * @property queueName The name of the Storage queue under a storage account that is the destination of an event subscription.
 * @property resourceId The Azure Resource ID of the storage account that contains the queue that is the destination of an event subscription.
 */
public data class StorageQueueEventSubscriptionDestinationResponse(
    public val endpointType: String,
    public val queueMessageTimeToLiveInSeconds: Double? = null,
    public val queueName: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.StorageQueueEventSubscriptionDestinationResponse):
            StorageQueueEventSubscriptionDestinationResponse =
            StorageQueueEventSubscriptionDestinationResponse(
                endpointType = javaType.endpointType(),
                queueMessageTimeToLiveInSeconds = javaType.queueMessageTimeToLiveInSeconds().map({ args0 ->
                    args0
                }).orElse(null),
                queueName = javaType.queueName().map({ args0 -> args0 }).orElse(null),
                resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
