@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SchemaRegistry].
 */
@PulumiTagMarker
public class SchemaRegistryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchemaRegistryArgs = SchemaRegistryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchemaRegistryArgsBuilder.() -> Unit) {
        val builder = SchemaRegistryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SchemaRegistry {
        val builtJavaResource = com.pulumi.azurenative.eventhub.SchemaRegistry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SchemaRegistry(builtJavaResource)
    }
}

/**
 * Single item in List or Get Schema Group operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * Other available API versions: 2023-01-01-preview, 2024-01-01.
 * ## Example Usage
 * ### SchemaRegistryCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schemaRegistry = new AzureNative.EventHub.SchemaRegistry("schemaRegistry", new()
 *     {
 *         GroupProperties = null,
 *         NamespaceName = "ali-ua-test-eh-system-1",
 *         ResourceGroupName = "alitest",
 *         SchemaCompatibility = "Forward",
 *         SchemaGroupName = "testSchemaGroup1",
 *         SchemaType = "Avro",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewSchemaRegistry(ctx, "schemaRegistry", &eventhub.SchemaRegistryArgs{
 * 			GroupProperties:     nil,
 * 			NamespaceName:       pulumi.String("ali-ua-test-eh-system-1"),
 * 			ResourceGroupName:   pulumi.String("alitest"),
 * 			SchemaCompatibility: pulumi.String("Forward"),
 * 			SchemaGroupName:     pulumi.String("testSchemaGroup1"),
 * 			SchemaType:          pulumi.String("Avro"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.SchemaRegistry;
 * import com.pulumi.azurenative.eventhub.SchemaRegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schemaRegistry = new SchemaRegistry("schemaRegistry", SchemaRegistryArgs.builder()
 *             .groupProperties()
 *             .namespaceName("ali-ua-test-eh-system-1")
 *             .resourceGroupName("alitest")
 *             .schemaCompatibility("Forward")
 *             .schemaGroupName("testSchemaGroup1")
 *             .schemaType("Avro")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:SchemaRegistry testSchemaGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/schemagroups/{schemaGroupName}
 * ```
 */
public class SchemaRegistry internal constructor(
    override val javaResource: com.pulumi.azurenative.eventhub.SchemaRegistry,
) : KotlinCustomResource(javaResource, SchemaRegistryMapper) {
    /**
     * Exact time the Schema Group was created.
     */
    public val createdAtUtc: Output<String>
        get() = javaResource.createdAtUtc().applyValue({ args0 -> args0 })

    /**
     * The ETag value.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * dictionary object for SchemaGroup group properties
     */
    public val groupProperties: Output<Map<String, String>>?
        get() = javaResource.groupProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val schemaCompatibility: Output<String>?
        get() = javaResource.schemaCompatibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val schemaType: Output<String>?
        get() = javaResource.schemaType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Exact time the Schema Group was updated
     */
    public val updatedAtUtc: Output<String>
        get() = javaResource.updatedAtUtc().applyValue({ args0 -> args0 })
}

public object SchemaRegistryMapper : ResourceMapper<SchemaRegistry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventhub.SchemaRegistry::class == javaResource::class

    override fun map(javaResource: Resource): SchemaRegistry = SchemaRegistry(
        javaResource as
            com.pulumi.azurenative.eventhub.SchemaRegistry,
    )
}

/**
 * @see [SchemaRegistry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SchemaRegistry].
 */
public suspend fun schemaRegistry(
    name: String,
    block: suspend SchemaRegistryResourceBuilder.() -> Unit,
): SchemaRegistry {
    val builder = SchemaRegistryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SchemaRegistry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schemaRegistry(name: String): SchemaRegistry {
    val builder = SchemaRegistryResourceBuilder()
    builder.name(name)
    return builder.build()
}
