@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The billing tier of this particular SKU.
 */
public enum class SkuTier(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.SkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.SkuTier> {
    Basic(com.pulumi.azurenative.eventhub.enums.SkuTier.Basic),
    Standard(com.pulumi.azurenative.eventhub.enums.SkuTier.Standard),
    Premium(com.pulumi.azurenative.eventhub.enums.SkuTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.SkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.SkuTier): SkuTier =
            SkuTier.values().first { it.javaValue == javaType }
    }
}
