@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.GetApplicationGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationGroupName The Application Group name
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 */
public data class GetApplicationGroupPlainArgs(
    public val applicationGroupName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.GetApplicationGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.GetApplicationGroupPlainArgs =
        com.pulumi.azurenative.eventhub.inputs.GetApplicationGroupPlainArgs.builder()
            .applicationGroupName(applicationGroupName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationGroupPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationGroupPlainArgsBuilder internal constructor() {
    private var applicationGroupName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Application Group name
     */
    @JvmName("wqnmjboyupfnsnsn")
    public suspend fun applicationGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationGroupName = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("bbvoerfqhyxrnhxs")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("banstmdljkkfgjar")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationGroupPlainArgs = GetApplicationGroupPlainArgs(
        applicationGroupName = applicationGroupName ?: throw
            PulumiNullFieldException("applicationGroupName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
