@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.GetConsumerGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property consumerGroupName The consumer group name
 * @property eventHubName The Event Hub name
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 */
public data class GetConsumerGroupPlainArgs(
    public val consumerGroupName: String,
    public val eventHubName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.GetConsumerGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.GetConsumerGroupPlainArgs =
        com.pulumi.azurenative.eventhub.inputs.GetConsumerGroupPlainArgs.builder()
            .consumerGroupName(consumerGroupName.let({ args0 -> args0 }))
            .eventHubName(eventHubName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConsumerGroupPlainArgs].
 */
@PulumiTagMarker
public class GetConsumerGroupPlainArgsBuilder internal constructor() {
    private var consumerGroupName: String? = null

    private var eventHubName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The consumer group name
     */
    @JvmName("vwgbnxuqnerayiuc")
    public suspend fun consumerGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.consumerGroupName = mapped
    }

    /**
     * @param value The Event Hub name
     */
    @JvmName("xjnrvyoilgxekcve")
    public suspend fun eventHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventHubName = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("ovmltsncoovwaivp")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("lojiwpxguoobivsm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConsumerGroupPlainArgs = GetConsumerGroupPlainArgs(
        consumerGroupName = consumerGroupName ?: throw PulumiNullFieldException("consumerGroupName"),
        eventHubName = eventHubName ?: throw PulumiNullFieldException("eventHubName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
