@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties to configure keyVault Properties
 * @property identity
 * @property keyName Name of the Key from KeyVault
 * @property keyVaultUri Uri of KeyVault
 * @property keyVersion Key Version
 */
public data class KeyVaultPropertiesArgs(
    public val identity: Output<UserAssignedIdentityPropertiesArgs>? = null,
    public val keyName: Output<String>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.eventhub.inputs.KeyVaultPropertiesArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var identity: Output<UserAssignedIdentityPropertiesArgs>? = null

    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("pjfoxlpumjodwjho")
    public suspend fun identity(`value`: Output<UserAssignedIdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value Name of the Key from KeyVault
     */
    @JvmName("jnbyxbuanwcsjipf")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Uri of KeyVault
     */
    @JvmName("qmlfgvubvgwlfkgn")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value Key Version
     */
    @JvmName("cmlilompggjbhxym")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value
     */
    @JvmName("hsfnqynkxdfuyavt")
    public suspend fun identity(`value`: UserAssignedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xrhwlamegqloaksc")
    public suspend
    fun identity(argument: suspend UserAssignedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedIdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Name of the Key from KeyVault
     */
    @JvmName("dehwdfmfaiegsbba")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Uri of KeyVault
     */
    @JvmName("fkivpnpjcagwylws")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value Key Version
     */
    @JvmName("lfcheylebeohlkey")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        identity = identity,
        keyName = keyName,
        keyVaultUri = keyVaultUri,
        keyVersion = keyVersion,
    )
}
