@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties to configure capture description for eventhub
 * @property destination Properties of Destination where capture will be stored. (Storage Account, Blob Names)
 * @property enabled A value that indicates whether capture description is enabled.
 * @property encoding Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in New API Version
 * @property intervalInSeconds The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between 60 to 900 seconds
 * @property sizeLimitInBytes The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between 10485760 to 524288000 bytes
 * @property skipEmptyArchives A value that indicates whether to Skip Empty Archives
 */
public data class CaptureDescriptionResponse(
    public val destination: DestinationResponse? = null,
    public val enabled: Boolean? = null,
    public val encoding: String? = null,
    public val intervalInSeconds: Int? = null,
    public val sizeLimitInBytes: Int? = null,
    public val skipEmptyArchives: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.CaptureDescriptionResponse):
            CaptureDescriptionResponse = CaptureDescriptionResponse(
            destination = javaType.destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.DestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
            sizeLimitInBytes = javaType.sizeLimitInBytes().map({ args0 -> args0 }).orElse(null),
            skipEmptyArchives = javaType.skipEmptyArchives().map({ args0 -> args0 }).orElse(null),
        )
    }
}
