@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Description of topic resource.
 * @property defaultAction Default Action for Network Rule Set
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ipRules List of IpRules
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
 * @property systemData The system meta data relating to this resource.
 * @property trustedServiceAccessEnabled Value that indicates whether Trusted Service Access is Enabled or not.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property virtualNetworkRules List VirtualNetwork Rules
 */
public data class GetNamespaceNetworkRuleSetResult(
    public val defaultAction: String? = null,
    public val id: String,
    public val ipRules: List<NWRuleSetIpRulesResponse>? = null,
    public val location: String,
    public val name: String,
    public val publicNetworkAccess: String? = null,
    public val systemData: SystemDataResponse,
    public val trustedServiceAccessEnabled: Boolean? = null,
    public val type: String,
    public val virtualNetworkRules: List<NWRuleSetVirtualNetworkRulesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventhub.outputs.GetNamespaceNetworkRuleSetResult):
            GetNamespaceNetworkRuleSetResult = GetNamespaceNetworkRuleSetResult(
            defaultAction = javaType.defaultAction().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.NWRuleSetIpRulesResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            trustedServiceAccessEnabled = javaType.trustedServiceAccessEnabled().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
            virtualNetworkRules = javaType.virtualNetworkRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventhub.kotlin.outputs.NWRuleSetVirtualNetworkRulesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
