@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.inputs

import com.pulumi.azurenative.extendedlocation.inputs.GetResourceSyncRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property childResourceName Resource Sync Rule name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Custom Locations name.
 */
public data class GetResourceSyncRulePlainArgs(
    public val childResourceName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.extendedlocation.inputs.GetResourceSyncRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.extendedlocation.inputs.GetResourceSyncRulePlainArgs =
        com.pulumi.azurenative.extendedlocation.inputs.GetResourceSyncRulePlainArgs.builder()
            .childResourceName(childResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceSyncRulePlainArgs].
 */
@PulumiTagMarker
public class GetResourceSyncRulePlainArgsBuilder internal constructor() {
    private var childResourceName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Resource Sync Rule name.
     */
    @JvmName("gfgiftfjjuwccbxh")
    public suspend fun childResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.childResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nbisiodwoidlxkjf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Custom Locations name.
     */
    @JvmName("hchjxrrlxrdfutij")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetResourceSyncRulePlainArgs = GetResourceSyncRulePlainArgs(
        childResourceName = childResourceName ?: throw PulumiNullFieldException("childResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
