@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin.inputs

import com.pulumi.azurenative.features.inputs.GetSubscriptionFeatureRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property featureName The feature name.
 * @property providerNamespace The provider namespace.
 */
public data class GetSubscriptionFeatureRegistrationPlainArgs(
    public val featureName: String,
    public val providerNamespace: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.features.inputs.GetSubscriptionFeatureRegistrationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.features.inputs.GetSubscriptionFeatureRegistrationPlainArgs =
        com.pulumi.azurenative.features.inputs.GetSubscriptionFeatureRegistrationPlainArgs.builder()
            .featureName(featureName.let({ args0 -> args0 }))
            .providerNamespace(providerNamespace.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubscriptionFeatureRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetSubscriptionFeatureRegistrationPlainArgsBuilder internal constructor() {
    private var featureName: String? = null

    private var providerNamespace: String? = null

    /**
     * @param value The feature name.
     */
    @JvmName("bpoougtfhgfukwsw")
    public suspend fun featureName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.featureName = mapped
    }

    /**
     * @param value The provider namespace.
     */
    @JvmName("wjiecxryjbgclygh")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    internal fun build(): GetSubscriptionFeatureRegistrationPlainArgs =
        GetSubscriptionFeatureRegistrationPlainArgs(
            featureName = featureName ?: throw PulumiNullFieldException("featureName"),
            providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
        )
}
