@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.inputs

import com.pulumi.azurenative.fluidrelay.inputs.GetFluidRelayServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fluidRelayServerName The Fluid Relay server resource name.
 * @property resourceGroup The resource group containing the resource.
 */
public data class GetFluidRelayServerPlainArgs(
    public val fluidRelayServerName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.fluidrelay.inputs.GetFluidRelayServerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.fluidrelay.inputs.GetFluidRelayServerPlainArgs =
        com.pulumi.azurenative.fluidrelay.inputs.GetFluidRelayServerPlainArgs.builder()
            .fluidRelayServerName(fluidRelayServerName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFluidRelayServerPlainArgs].
 */
@PulumiTagMarker
public class GetFluidRelayServerPlainArgsBuilder internal constructor() {
    private var fluidRelayServerName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value The Fluid Relay server resource name.
     */
    @JvmName("pbjkuoggmjssgvgy")
    public suspend fun fluidRelayServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fluidRelayServerName = mapped
    }

    /**
     * @param value The resource group containing the resource.
     */
    @JvmName("ccqjvmaypweynwfh")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetFluidRelayServerPlainArgs = GetFluidRelayServerPlainArgs(
        fluidRelayServerName = fluidRelayServerName ?: throw
            PulumiNullFieldException("fluidRelayServerName"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
    )
}
