@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.inputs

import com.pulumi.azurenative.fluidrelay.inputs.ListFluidRelayServerKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fluidRelayServerName The Fluid Relay server resource name.
 * @property resourceGroup The resource group containing the resource.
 */
public data class ListFluidRelayServerKeysPlainArgs(
    public val fluidRelayServerName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.fluidrelay.inputs.ListFluidRelayServerKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.fluidrelay.inputs.ListFluidRelayServerKeysPlainArgs =
        com.pulumi.azurenative.fluidrelay.inputs.ListFluidRelayServerKeysPlainArgs.builder()
            .fluidRelayServerName(fluidRelayServerName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFluidRelayServerKeysPlainArgs].
 */
@PulumiTagMarker
public class ListFluidRelayServerKeysPlainArgsBuilder internal constructor() {
    private var fluidRelayServerName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value The Fluid Relay server resource name.
     */
    @JvmName("mvswlwkvnsenskmm")
    public suspend fun fluidRelayServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fluidRelayServerName = mapped
    }

    /**
     * @param value The resource group containing the resource.
     */
    @JvmName("vsdhaoldpkpwjgrw")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): ListFluidRelayServerKeysPlainArgs = ListFluidRelayServerKeysPlainArgs(
        fluidRelayServerName = fluidRelayServerName ?: throw
            PulumiNullFieldException("fluidRelayServerName"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
    )
}
