@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.inputs

import com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property guestConfigurationAssignmentName The guest configuration assignment name.
 * @property resourceGroupName The resource group name.
 * @property vmName The name of the virtual machine.
 */
public data class GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs(
    public val guestConfigurationAssignmentName: String,
    public val resourceGroupName: String,
    public val vmName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs =
        com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs.builder()
            .guestConfigurationAssignmentName(guestConfigurationAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmName(vmName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgsBuilder internal
constructor() {
    private var guestConfigurationAssignmentName: String? = null

    private var resourceGroupName: String? = null

    private var vmName: String? = null

    /**
     * @param value The guest configuration assignment name.
     */
    @JvmName("mgoxromojursxpyr")
    public suspend fun guestConfigurationAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.guestConfigurationAssignmentName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("fxghupcfvdjmqvfh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine.
     */
    @JvmName("dcivdjiilqirosmt")
    public suspend fun vmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmName = mapped
    }

    internal fun build(): GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs =
        GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs(
            guestConfigurationAssignmentName = guestConfigurationAssignmentName ?: throw
                PulumiNullFieldException("guestConfigurationAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vmName = vmName ?: throw PulumiNullFieldException("vmName"),
        )
}
