@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The guest configuration assignment resource.
 * @property complianceStatus A value indicating compliance status of the machine for the assigned guest configuration.
 * @property properties Properties of a guest configuration assignment resource.
 * @property reasons Compliance reason and reason code for a resource.
 * @property resourceId Name of the guest configuration assignment resource setting.
 */
public data class AssignmentReportResourceResponse(
    public val complianceStatus: String,
    public val properties: Any,
    public val reasons: List<AssignmentReportResourceComplianceReasonResponse>? = null,
    public val resourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.AssignmentReportResourceResponse):
            AssignmentReportResourceResponse = AssignmentReportResourceResponse(
            complianceStatus = javaType.complianceStatus(),
            properties = javaType.properties(),
            reasons = javaType.reasons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.AssignmentReportResourceComplianceReasonResponse.Companion.toKotlin(args0)
                })
            }),
            resourceId = javaType.resourceId(),
        )
    }
}
