@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin

import com.pulumi.azurenative.hanaonazure.HanaonazureFunctions.getProviderInstancePlain
import com.pulumi.azurenative.hanaonazure.HanaonazureFunctions.getSapMonitorPlain
import com.pulumi.azurenative.hanaonazure.kotlin.inputs.GetProviderInstancePlainArgs
import com.pulumi.azurenative.hanaonazure.kotlin.inputs.GetProviderInstancePlainArgsBuilder
import com.pulumi.azurenative.hanaonazure.kotlin.inputs.GetSapMonitorPlainArgs
import com.pulumi.azurenative.hanaonazure.kotlin.inputs.GetSapMonitorPlainArgsBuilder
import com.pulumi.azurenative.hanaonazure.kotlin.outputs.GetProviderInstanceResult
import com.pulumi.azurenative.hanaonazure.kotlin.outputs.GetSapMonitorResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.hanaonazure.kotlin.outputs.GetProviderInstanceResult.Companion.toKotlin as getProviderInstanceResultToKotlin
import com.pulumi.azurenative.hanaonazure.kotlin.outputs.GetSapMonitorResult.Companion.toKotlin as getSapMonitorResultToKotlin

public object HanaonazureFunctions {
    /**
     * Gets properties of a provider instance for the specified subscription, resource group, SapMonitor name, and resource name.
     * Azure REST API version: 2020-02-07-preview.
     * @param argument null
     * @return A provider instance associated with a SAP monitor.
     */
    public suspend fun getProviderInstance(argument: GetProviderInstancePlainArgs):
        GetProviderInstanceResult =
        getProviderInstanceResultToKotlin(getProviderInstancePlain(argument.toJava()).await())

    /**
     * @see [getProviderInstance].
     * @param providerInstanceName Name of the provider instance.
     * @param resourceGroupName Name of the resource group.
     * @param sapMonitorName Name of the SAP monitor resource.
     * @return A provider instance associated with a SAP monitor.
     */
    public suspend fun getProviderInstance(
        providerInstanceName: String,
        resourceGroupName: String,
        sapMonitorName: String,
    ): GetProviderInstanceResult {
        val argument = GetProviderInstancePlainArgs(
            providerInstanceName = providerInstanceName,
            resourceGroupName = resourceGroupName,
            sapMonitorName = sapMonitorName,
        )
        return getProviderInstanceResultToKotlin(getProviderInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getProviderInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hanaonazure&#46;kotlin&#46;inputs&#46;GetProviderInstancePlainArgs].
     * @return A provider instance associated with a SAP monitor.
     */
    public suspend
    fun getProviderInstance(argument: suspend GetProviderInstancePlainArgsBuilder.() -> Unit):
        GetProviderInstanceResult {
        val builder = GetProviderInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProviderInstanceResultToKotlin(getProviderInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets properties of a SAP monitor for the specified subscription, resource group, and resource name.
     * Azure REST API version: 2020-02-07-preview.
     * @param argument null
     * @return SAP monitor info on Azure (ARM properties and SAP monitor properties)
     */
    public suspend fun getSapMonitor(argument: GetSapMonitorPlainArgs): GetSapMonitorResult =
        getSapMonitorResultToKotlin(getSapMonitorPlain(argument.toJava()).await())

    /**
     * @see [getSapMonitor].
     * @param resourceGroupName Name of the resource group.
     * @param sapMonitorName Name of the SAP monitor resource.
     * @return SAP monitor info on Azure (ARM properties and SAP monitor properties)
     */
    public suspend fun getSapMonitor(resourceGroupName: String, sapMonitorName: String):
        GetSapMonitorResult {
        val argument = GetSapMonitorPlainArgs(
            resourceGroupName = resourceGroupName,
            sapMonitorName = sapMonitorName,
        )
        return getSapMonitorResultToKotlin(getSapMonitorPlain(argument.toJava()).await())
    }

    /**
     * @see [getSapMonitor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;hanaonazure&#46;kotlin&#46;inputs&#46;GetSapMonitorPlainArgs].
     * @return SAP monitor info on Azure (ARM properties and SAP monitor properties)
     */
    public suspend fun getSapMonitor(argument: suspend GetSapMonitorPlainArgsBuilder.() -> Unit):
        GetSapMonitorResult {
        val builder = GetSapMonitorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSapMonitorResultToKotlin(getSapMonitorPlain(builtArgument.toJava()).await())
    }
}
