@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin.inputs

import com.pulumi.azurenative.hanaonazure.inputs.GetSapMonitorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Name of the resource group.
 * @property sapMonitorName Name of the SAP monitor resource.
 */
public data class GetSapMonitorPlainArgs(
    public val resourceGroupName: String,
    public val sapMonitorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hanaonazure.inputs.GetSapMonitorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hanaonazure.inputs.GetSapMonitorPlainArgs =
        com.pulumi.azurenative.hanaonazure.inputs.GetSapMonitorPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapMonitorName(sapMonitorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSapMonitorPlainArgs].
 */
@PulumiTagMarker
public class GetSapMonitorPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sapMonitorName: String? = null

    /**
     * @param value Name of the resource group.
     */
    @JvmName("cstwtlyxwfrjekpl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("rgupofdhniarqwen")
    public suspend fun sapMonitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapMonitorName = mapped
    }

    internal fun build(): GetSapMonitorPlainArgs = GetSapMonitorPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapMonitorName = sapMonitorName ?: throw PulumiNullFieldException("sapMonitorName"),
    )
}
