@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmClusterSecurityDomainPropertiesResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmClusterSkuResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmPropertiesResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmClusterSecurityDomainPropertiesResponse.Companion.toKotlin as cloudHsmClusterSecurityDomainPropertiesResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmClusterSkuResponse.Companion.toKotlin as cloudHsmClusterSkuResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmPropertiesResponse.Companion.toKotlin as cloudHsmPropertiesResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CloudHsmCluster].
 */
@PulumiTagMarker
public class CloudHsmClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudHsmClusterArgs = CloudHsmClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudHsmClusterArgsBuilder.() -> Unit) {
        val builder = CloudHsmClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CloudHsmCluster {
        val builtJavaResource =
            com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudHsmCluster(builtJavaResource)
    }
}

/**
 * Resource information with extended details.
 * Azure REST API version: 2022-08-31-preview.
 * ## Example Usage
 * ### CloudHsmCluster_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudHsmCluster = new AzureNative.HardwareSecurityModules.CloudHsmCluster("cloudHsmCluster", new()
 *     {
 *         CloudHsmClusterName = "chsm1",
 *         Location = "eastus2",
 *         ResourceGroupName = "rgcloudhsm",
 *         SecurityDomain = new AzureNative.HardwareSecurityModules.Inputs.CloudHsmClusterSecurityDomainPropertiesArgs
 *         {
 *             FipsState = 2,
 *         },
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.CloudHsmClusterSkuArgs
 *         {
 *             Family = "B",
 *             Name = AzureNative.HardwareSecurityModules.CloudHsmClusterSkuName.Standard_B1,
 *         },
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewCloudHsmCluster(ctx, "cloudHsmCluster", &hardwaresecuritymodules.CloudHsmClusterArgs{
 * 			CloudHsmClusterName: pulumi.String("chsm1"),
 * 			Location:            pulumi.String("eastus2"),
 * 			ResourceGroupName:   pulumi.String("rgcloudhsm"),
 * 			SecurityDomain: &hardwaresecuritymodules.CloudHsmClusterSecurityDomainPropertiesArgs{
 * 				FipsState: pulumi.Int(2),
 * 			},
 * 			Sku: &hardwaresecuritymodules.CloudHsmClusterSkuArgs{
 * 				Family: pulumi.String("B"),
 * 				Name:   hardwaresecuritymodules.CloudHsmClusterSkuName_Standard_B1,
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmCluster;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudHsmCluster = new CloudHsmCluster("cloudHsmCluster", CloudHsmClusterArgs.builder()
 *             .cloudHsmClusterName("chsm1")
 *             .location("eastus2")
 *             .resourceGroupName("rgcloudhsm")
 *             .securityDomain(Map.of("fipsState", 2))
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "B"),
 *                 Map.entry("name", "Standard_B1")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hardwaresecuritymodules:CloudHsmCluster chsm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}
 * ```
 */
public class CloudHsmCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmCluster,
) : KotlinCustomResource(javaResource, CloudHsmClusterMapper) {
    /**
     * The Cloud HSM Cluster's auto-generated Domain Name Label Scope
     */
    public val autoGeneratedDomainNameLabelScope: Output<String>?
        get() = javaResource.autoGeneratedDomainNameLabelScope().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * An array of Cloud HSM Cluster's HSMs
     */
    public val hsms: Output<List<CloudHsmPropertiesResponse>>?
        get() = javaResource.hsms().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> cloudHsmPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connection resources
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The Cloud HSM Cluster's provisioningState
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Cloud HSM Cluster public network access
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Security domain properties information for Cloud HSM cluster
     */
    public val securityDomain: Output<CloudHsmClusterSecurityDomainPropertiesResponse>?
        get() = javaResource.securityDomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cloudHsmClusterSecurityDomainPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SKU details
     */
    public val sku: Output<CloudHsmClusterSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cloudHsmClusterSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CloudHsmClusterMapper : ResourceMapper<CloudHsmCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmCluster::class == javaResource::class

    override fun map(javaResource: Resource): CloudHsmCluster = CloudHsmCluster(
        javaResource as
            com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmCluster,
    )
}

/**
 * @see [CloudHsmCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudHsmCluster].
 */
public suspend fun cloudHsmCluster(
    name: String,
    block: suspend CloudHsmClusterResourceBuilder.() -> Unit,
): CloudHsmCluster {
    val builder = CloudHsmClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudHsmCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudHsmCluster(name: String): CloudHsmCluster {
    val builder = CloudHsmClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
